/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import dev.architectury.fluid.FluidStack;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.thermo.ThermoBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Util;

public class ThermoTile
extends AbstractEnergyProvider<ThermoBlock>
implements IInventoryHolder,
ITankHolder {
    public long generating;

    public ThermoTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.THERMO_GEN.get(), pos, state, variant);
        this.tank.setCapacity(FluidStack.bucketAmount() * 4L).validate(stack -> PowahAPI.getCoolant(stack.getFluid()) != 0).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public ThermoTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(class_2487 nbt) {
        super.readSync(nbt);
        this.generating = nbt.method_10537("generating");
    }

    @Override
    public class_2487 writeSync(class_2487 nbt) {
        nbt.method_10544("generating", this.generating);
        return super.writeSync(nbt);
    }

    @Override
    protected int postTick(class_1937 world) {
        boolean flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        boolean i = false;
        if (!this.isRemote() && this.checkRedstone() && !this.tank.isEmpty()) {
            FluidStack fluid = this.tank.getFluid();
            int fluidCooling = PowahAPI.getCoolant(fluid.getFluid());
            if (fluidCooling != 0) {
                class_2338 heatPos = this.field_11867.method_10074();
                class_2680 state = world.method_8320(heatPos);
                class_2248 block = state.method_26204();
                int heat = PowahAPI.getHeatSource(block);
                if (!this.energy.isFull() && heat != 0) {
                    class_2404 fluidBlock;
                    if (block instanceof class_2404 && !(fluidBlock = (class_2404)block).method_9545(state).method_15771()) {
                        int level = (Integer)state.method_11654((class_2769)class_2404.field_11278);
                        heat = (int)((float)heat / ((float)level + 1.0f));
                    }
                    double heatRatio = (double)heat / 1000.0;
                    double coolingRatio = Math.max(1.0, (1.0 + (double)Math.abs(fluidCooling)) / 2.0);
                    this.generating = (int)(heatRatio * coolingRatio * (double)this.getGeneration());
                    this.energy.produce(this.generating);
                    if (world.method_8510() % 40L == 0L) {
                        this.tank.drain(Util.millibucketAmount(), false);
                    }
                } else {
                    this.generating = 0L;
                }
            } else {
                this.generating = 0L;
            }
        }
        return flag || this.generating > 0L ? 5 : -1;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean keepFluid() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }
}

